/*****************************************************************************
*  LPC82x SCT PWM for LPC824 LPCXpresso board
*
*  1. Use SCT timer to generate a PWM output signal @ CTOUT_0
*  2. Every time P0_4 goes high to low increase the duty cycle.
*  3. Every time P0_12 goes high to low decrease the duty cycle.
*****************************************************************************/

#include "board.h"


#define match_value0 (19)
#define match_value1 (5)


extern void sct_fsm_init (void);


void sct_fsm_init (void)
{


	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_AUTOLIMIT_L );									/* SPLIT */

	Chip_SCT_SetControl(LPC_SCT, SCT_CTRL_PRE_L(SystemCoreClock/1000000-1));            /* set prescaler, SCT clock = 1 MHz, clear counter   */



	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0, match_value0);					// match 0 @ 20/1MHz = 20 usec (50 KHz PWM freq)
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, match_value0);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_1, match_value1);					// match 1 used for duty cycle (in 20 steps)
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_1, match_value1);

	/* OUTPUT registers */

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_0 );  			 		// event 0 will set SCT_OUT_0
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_1);                                         // event 1 will clear SCT_OUT_0


	/* EVENT registers */

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_STATE0);					    						// event 0 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH0		|   	// MATCHSEL[3:0] = related to match 0
                                                                              SCT_COMBMODE_MATCH	|   	// COMBMODE[13:12] = match condition only
                                                                              SCT_STATELD_1			|   	// STATELD[14] = STATEV is loaded into state
                                                                              SCT_STATEEV_0			)); 	// STATEV[15] = 0

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_1, ENABLE_STATE0);												// event 1 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH1		|   		// MATCHSEL[3:0] = related to match 1
                                                                              SCT_COMBMODE_MATCH	|   	// COMBMODE[13:12] = match condition only
                                                                              SCT_STATELD_1			|   		// STATELD[14] = STATEV is loaded into state
                                                                              SCT_STATEEV_0	        )); 	// STATEV[15] = 0



	Chip_SCT_ClearControl(LPC_SCT , SCT_CTRL_HALT_L);

}



int main (void)
{

  static uint8_t trg1 = 1;
  static uint8_t trg2 = 1;

	/* Generic Initialization */
	SystemCoreClockUpdate();
	Board_Init();

	Chip_SCT_Init(LPC_SCT);														            /* enable the SCT clock     */

    Chip_SWM_Init();
    Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);

	Chip_SWM_MovablePinAssign(SWM_SCT_OUT0_O, 16);                  // SCT OUTP_0 at P0.16

	Chip_SWM_FixedPinEnable(SWM_FIXED_ADC11, false);
  
  Chip_GPIO_SetPinDIRInput(LPC_GPIO_PORT,0, 12);


    sct_fsm_init();                       		/* Initialize SCT                           */


    while (1)                                                       // loop forever
    {
        if (!Chip_GPIO_GetPinState (LPC_GPIO_PORT,0,4) && trg1)          // P0.4 high to low?
        {
            trg1 = 0;                                               // trigger P0.4 low
            if (LPC_SCT->MATCHREL[1].L < 19)
                LPC_SCT->MATCHREL[1].L ++;                         // increase PWM dutycycle
        }
        else if (Chip_GPIO_GetPinState(LPC_GPIO_PORT,0,4) && !trg1)    // P0.4 low to high?
        {
            trg1 = 1;                                               // trigger P0.4 high
        }

        if (!Chip_GPIO_GetPinState(LPC_GPIO_PORT,0,12) && trg2)         // P0.12 high to low?
        {
            trg2 = 0;                                             // trigger P0.12 low
            if (LPC_SCT->MATCHREL[1].L > 0)
                LPC_SCT->MATCHREL[1].L --;                        // increase PWM dutycycle
        }
        else if (Chip_GPIO_GetPinState(LPC_GPIO_PORT,0,12) && !trg2)    // P0.12 low to high?
        {
            trg2 = 1;                                             // trigger P0.12 high
        }
    }
}



